rooms = [
["CANYON VIEW",
"Rocky outcropping, unspectacular by itself, overlooks canyon. Canyon overlooks itself by unspectacular outcropping, rocky."],
["COAL MINE",
"Mysterious darkened corridors. Alone, all alone. Corridors, darkened, mysterious."],
["BAGGAGE CLAIM",
"Luggage coming and going; Belts running to connect to running belts. Going and coming, luggage."],
["BOOK-LINED STUDY",
"Many books, blank and printed. One ruled: One. Printed and blank books, many."],
["ROUND CHAMBER",
"Targets everywhere, circles all around. All circles, everywhere: targets."]
]

points = [
"One point ... four more, four. Point one!",
"Two points ... three more, three. Points: Two.",
"Three points ... two more, two. Points: Three.",
"Four points ... one more, one. Points: Four.",
"Five points won! You won! Points: Five."
]

counter = 0
failed = 0

function print_room(num) {
  var room = '<div class="room">' + 
    '<div class="room-title">' + rooms[num][0] + '</div>' +
    rooms[num][1] +
    '</div>';  
  $('#content').append(room);
  scroll_to_end();
}

function print_command(command) {
  var com = '<div class="command">&gt;&nbsp;<span>' + command + '</span></div>';
  $('#content').append(com);
  scroll_to_end();
}

function print_response(response) {
  var resp = '<div class="response">' + response + '</div>';
  $('#content').append(resp);
  scroll_to_end();
}

function print_message(message) {
  var resp = '<div class="message">' + message + '</div>';
  $('#content').append(resp);
  scroll_to_end();
}

function print_points(num) {
  print_response(points[num]);
}

function print_title() {
  print_message("I PALINDROME I");
}

function finish_game() {
  print_message("*** YES, YOU HAVE WON! HAVE YOU? YES! ***");
  $('.input-container').hide();
}

function scroll_to_end() {
  // http://stackoverflow.com/questions/1890995/jquery-scroll-to-bottom-of-page-iframe
  $('html, body').animate({ 
     scrollTop: $(document).height()-$(window).height()}, 
     500, 
     "easeOutQuint"
  );
}
 
function get_words(txt) {
  txt = txt.replace(/[^a-zA-Z0-9\s]/g, ' ');
  txt = $.trim(txt);
  return txt.split(' ');
}

function parse_input(txt) {
  txt = $.trim(txt).replace(/\s+/, ' ').toUpperCase();
  print_command(txt);

  var user_words = get_words(txt);
  var room_words = get_words(rooms[counter][0]);

  user_words.reverse();
  if (user_words.compare(room_words)) {
    print_points(counter);
    counter++;

    if (counter == 5) {
      finish_game();
    } else {
      print_room(counter);
    }
  } else {
    if (failed++ < 3) {
      alert("... RETURN now, return ...");
    } else {
      print_response("... NOW, THINK! What action? What words? What action? What? THINK NOW! ...");
    }
    counter = 0;
    print_title();
    print_room(counter);
  }
}

function pal_init() {
  // http://www.hunlock.com/blogs/Mastering_Javascript_Arrays#quickIDX41
  Array.prototype.compare = function(testArr) {
    if (this.length != testArr.length) return false;
    for (var i = 0; i < testArr.length; i++) {
      if (this[i].compare) { 
        if (!this[i].compare(testArr[i])) return false;
      }
      if (this[i] !== testArr[i]) return false;
    }
    return true;
  };

  $("#input").keydown(function(event){
    if (event.keyCode == 13){
      parse_input($("#input").val());
      $("#input").val("");
      return false;
    }
  });

  print_title();
  print_room(0);
}